# 星青创聚合登录 PHP SDK

## 安装

将 `OAuth.php` 文件复制到您的项目中并引入即可。

## 快速开始

```php
<?php
require_once 'OAuth.php';

// 配置
$config = [
    'apiurl'   => 'https://login.xingqingchuang.com',
    'appid'    => '您的APPID',
    'appkey'   => '您的APPKEY',
    'callback' => 'https://您的网站/callback.php',
];

$oauth = new OAuth($config);

// 发起QQ登录
$result = $oauth->login('qq');
if ($result['code'] == 0) {
    header('Location: ' . $result['url']);
    exit;
}
```

## 回调处理

```php
<?php
require_once 'OAuth.php';

$oauth = new OAuth($config);

// 获取用户信息
$code = $_GET['code'] ?? '';
$result = $oauth->callback($code);

if ($result['code'] == 0) {
    $socialUid = $result['social_uid'];  // 用户唯一标识
    $nickname  = $result['nickname'];    // 昵称
    $faceimg   = $result['faceimg'];     // 头像
    $gender    = $result['gender'];      // 性别
    
    // 处理您的登录逻辑...
}
```

## 支持的登录类型

| type | 平台 |
|------|------|
| qq | QQ登录 |
| wx | 微信登录 |
| alipay | 支付宝登录 |
| sina | 微博登录 |
| baidu | 百度登录 |
| github | GitHub登录 |
| gitee | Gitee登录 |
| google | 谷歌登录 |
| microsoft | 微软登录 |
| dingtalk | 钉钉登录 |
| feishu | 飞书登录 |
| wework | 企业微信 |
| douyin | 抖音登录 |
| huawei | 华为登录 |
| xiaomi | 小米登录 |
| bilibili | 哔哩哔哩 |
